﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

using Ivi.Driver.Interop;
using Agilent.AgM9393.Interop;
using Agilent.AgM938x.Interop;
using Agilent.AgM90XA.Interop;
using Agilent.M9000;
using Agilent.M9000.Interfaces;
using Ivi.Visa.Interop;
using DataLog = PowerAmpDemoNS.DataLog;
using VSG_SFP;

namespace NSM9393A
{
    public partial class Vsag_M9393A : PowerAmpDemoNS.IVsag
    {
        public bool simulateHardware { set; get; }
        public string VsaResource { set; get; }
        public string VsgResource { set; get; }
        public string M9018resource { set; get; }
        public bool useM9300 { set; get; }
        public bool showM90xaDisplay { set; get; }
        public bool fftServo { set; get; }
        public bool fftAcpr { set; get; }
        public bool alignVsg { set; get; }
        public bool alignVsa { set; get; }
        // Calibration Data
        private double[] inputCalFreqs;
        private double[,] inputCalValues;
        private double[] outputCalFreqs;
        private double[,] outputCalValues;

        // Instrument Drivers
        private IAgM9393 Vsa;
        private IAgM938xEx Vsg;

        // Data log from creating object
        private DataLog dataLog;

        // VISA session variables used to send SCPI commands to X-Apps or VISA instruments
        private int rm = 0;
        private int xApp;

        // M9300 Application variables
        private M9000Session M9000;
        private M9000Resource m9000Resource;
        private AgM90XA M90XA;
        private string _key;
        private const string ResourcePluginType = "AgM9393.Ivi";
        private string M90XAresource = "TCPIP0::127.0.0.1::hislip0::INSTR";

        // Power Meter for Loss Calibration
        private ResourceManager oRm;
        private FormattedIO488 pm;

        // Waveform Information use with Get Arb Info command
        private double arbSampleRate = 0;
        private double arbRmsValue = 0;
        private double arbScale = 0.5;
        private AgM938xMarkerEnum rfMarker = AgM938xMarkerEnum.AgM938xMarkerNone;
        private AgM938xMarkerEnum alcMarker = AgM938xMarkerEnum.AgM938xMarkerNone;

        // Frequency and Power Levels
        private double[] acprOffsetFreq = new double[6];
        // Acqusition and channel filter
        private double ifBandwidth = 40e6;
        private double sampleRate = 5e6;
        private double pwrDuration = 100e-6;
        private double acprDuration = 500e-6;
        private AgM9393ChannelFilterShapeEnum FilterType =
             AgM9393ChannelFilterShapeEnum.AgM9393ChannelFilterShapeRootRaisedCosine;
        private double FilterAlpha = 0.22;
        private double FilterBw = 3840000.0;
        private AgM9393ChannelFilterShapeEnum acprFilterType = 
            AgM9393ChannelFilterShapeEnum.AgM9393ChannelFilterShapeRootRaisedCosine;
        private double acprFilterBw = 3.84e6;
        private double acprFilterAlpha = 0.22;
        private double acprSpan = 25e6;
        private int numAcprMeas = 4;
        private double refLevelMargin = 5;
        private double digLevelOffset = -5;
        private double servoHeadRoom = 3;
        private double servoOverheadTime = 600e-6;

        // Set Default EXT Trigger source to be front panel
        private AgM9393TriggerEnum vsaTriggerSource = AgM9393TriggerEnum.AgM9393TriggerFrontPanelTrigger1;
        
        // FFT Acquisition
        private AgM9393FFTAcquisitionLengthEnum fftSize = AgM9393FFTAcquisitionLengthEnum.AgM9393FFTAcquisitionLength_256;
        //private int fftSize = 256;
        private AgM9393FFTWindowShapeEnum fftWindow = AgM9393FFTWindowShapeEnum.AgM9393FFTWindowShapeHann;
        private double[] fftData;
        private double windowEnbw = 1.0;
        // Spectrum Acquisition
        private double[] spectrumData = new double[53];
        // Gain Compression Test
        private double[] iqData = new double[100];
        private double[] inPower = new double[100];
        private double[] outPower = new double[100];
        private double[] gainArray = new double[100];

        private Stopwatch sw1 = new Stopwatch();

        // Variables for M9381A Power Search and M9391A Amplitude Alignments
        private double[] rfOffset;
        private double[] scaleOffset;
        private bool[] doVsaAlign;
        private bool[] doPowerSearch;

        private vsgMonitor myVsgMonitor;
        private vsaMonitor_M9393A myVsaMonitor;

        public Vsag_M9393A(int numTests, DataLog parentDataLog)
        {
            dataLog = parentDataLog;
            // Variables for M9381A Power Search and M9391A Alignments
            doVsaAlign = new bool[numTests];
            doPowerSearch = new bool[numTests];
            rfOffset = new double[numTests];
            scaleOffset = new double[numTests];

            // Load some default calibration data
            initCalData();
        }

        public void initVsagAlignments()
        {
            // Reset the doPowerSeach booleans to force power search run after each init
            for (int i = 0; i < doPowerSearch.Length; i++)
            {
                doVsaAlign[i] = true;
                doPowerSearch[i] = true;
                rfOffset[i] = 0;
                scaleOffset[i] = 1;
            }
        }
        public void showVsaMonitor()
        {
            myVsaMonitor = new vsaMonitor_M9393A(Vsa);
            myVsaMonitor.Show();
        }

        public void showVsgMonitor()
        {
            myVsgMonitor = new vsgMonitor(Vsg);
            myVsgMonitor.Show();
        }

        public void stopVsaMonitor()
        {
            myVsaMonitor.Dispose();
            myVsaMonitor = null;
        }

        public void stopVsgMonitor()
        {
            myVsgMonitor.Dispose();
            myVsgMonitor = null;
        }
    }
}
